const settings = window.wc.wcSettings.getSetting('wpgfull_data');
const Content = () => {
    return window.wp.htmlEntities.decodeEntities(settings.description || '');
};

let label = window.wp.htmlEntities.decodeEntities(settings.title);
if (settings.display_icon == 'no') {
    label = React.createElement('div', {
        class: 'wpgmethod',
        style: {
            display: 'flex',
        }
    },

    React.createElement('img', {
        src: settings.icon,
        alt: settings.title,
    }),

    settings.title

    );   
}

const Wpg_Gateway = {
    name: 'wpgfull',
    label: label,
    content: Object(window.wp.element.createElement)(Content, null),
    edit: Object(window.wp.element.createElement)(Content, null),
    canMakePayment: () => true,
    ariaLabel: settings.title || 'WPG Commerce',
    supports: {
        features: settings.supports,
        showSavedCards: true,
        showSaveOption: true,
    },
};
window.wc.wcBlocksRegistry.registerPaymentMethod(Wpg_Gateway);